#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>

#include <dlfcn.h>




static int debug = 0;

static const char libsysconfcpus_debug_envvar[] = "LIBSYSCONFCPUS_DEBUG";

static int do_debug() {
	return (debug || getenv(libsysconfcpus_debug_envvar));
}

static void dprintf(char *fmt, ...) {
	va_list ap;
	if (do_debug()) {
		va_start(ap, fmt);
		vfprintf(stderr, fmt, ap);
		va_end(ap);
		fflush(stderr);
	}
}





static void _libsysconfcpus_init(void) __attribute__((constructor));
static void _libsysconfcpus_fini(void) __attribute__((destructor));

static void _libsysconfcpus_init(void) {
	dprintf("libsysconfcpus: starting up\n");
}

static void _libsysconfcpus_fini(void) {
	dprintf("libsysconfcpus: shutting down\n");
}




long sysconf(int name) {
	static void *libc_handle = NULL;
	static long (*underlying)(int name);
	long retval;
	const char *err;

	dprintf("libsysconfcpus: sysconf(%d): entered\n", name);

	if (!libc_handle) {
		libc_handle = dlopen("libc.so.6", RTLD_LAZY);
		dprintf("libsysconfcpus: sysconf: libc_handle = 0x%x\n", libc_handle);
		if (!libc_handle) {
			fprintf(stderr, "libsysconfcpus: Error: Unable to find libc.so: %s\n", dlerror());
			exit(1);
		}

		dlerror();
		underlying = dlsym(libc_handle, "sysconf");
		dprintf("libsysconfcpus: sysconf: underlying = 0x%x\n", underlying);
		err = dlerror();
		if (err) {
			dprintf("libsysconfcpus: sysconf: err = \"%s\"\n", err);
		}
		if (!underlying || err) {
			fprintf(stderr, "libsysconfcpus: Error: Unable to find the underlying sysconf(): %s\n", dlerror());
			exit(1);
		}
	}

	dprintf("libsysconfcpus: about to call underlying sysconf()\n");
	retval = (*underlying)(name);
	dprintf("libsysconfcpus: underlying sysconf(%d) = %ld\n", name, retval);

	return retval;
}

